clear

capture log close
global raw "/disk/homedirs/frenche/research/merge"
log using $raw/gen_mergecouples.log, replace
set more off


use $raw/merge.dta


* Mergehas pce in 2005 $, change to 2014 $
drop pce
gen pce = .

replace pce=71.6974	 if year==1996
replace pce=72.9350	 if year==1997
replace pce=73.4949	 if year==1998
replace pce=74.5743	 if year==1999
replace pce=76.4325	 if year==2000
replace pce=77.9081	 if year==2001
replace pce=78.9535	 if year==2002
replace pce=80.5156	 if year==2003
replace pce=82.4749	 if year==2004
replace pce=84.8268	 if year==2005
replace pce=87.0959	 if year==2006
replace pce=89.2768	 if year==2007
replace pce=92.0019	 if year==2008
replace pce=91.9422	 if year==2009
replace pce=93.4620	 if year==2010
replace pce=95.7568  if year==2011
replace pce=97.5157  if year==2012
replace pce=98.6844  if year==2013
replace pce=100      if year==2014



replace income = income*(100/pce)
replace totalexp = totalexp*(100/pce)
replace oop = oop*(100/pce)
replace medicare = medicare*(100/pce)
replace medicaid = medicaid*(100/pce)
replace privins = privins*(100/pce)
replace otherexp = otherexp*(100/pce)

replace secondaryinsprem = secondaryinsprem*(100/pce)
replace partapremium = partapremium*(100/pce)
replace partbpremium = partbpremium*(100/pce)
replace totpremium = totpremium*(100/pce)
replace ooppluspremium = ooppluspremium*(100/pce)
gen oop2= ooppluspremium - partbpremium


unab exps: exp_* xexp_* xpay_*
foreach x in `exps' {
replace `x' = `x'*(100/pce)
}
*

drop exp_*
gen exp_hosp = xexp_inpatient + xexp_outpatient
gen exp_hosp_in = xexp_inpatient
gen exp_hosp_out = xexp_outpatient
gen exp_ps = xexp_dental + xexp_medprov
gen exp_nursing = xexp_facility  + xexp_inst
gen exp_drugs = xexp_drugs
gen exp_other = xexp_home + xexp_hospice 
gen totalexp_nonurse = totalexp - exp_nursing



gen govt_other = otherexp - xpay_unclib
gen unclib = xpay_unclib
gen govt = medicare+medicaid+govt_other



* we count a person as participating in medicaid if medicaid payments are positive
replace medicaidind=1 if medicaid>0	

save $raw/mergecouples, replace

cap log close
